from itertools import combinations

def vektorski_proizvod(o, a, b):
    return (a[0] - o[0]) * (b[1] - o[1]) - (a[1] - o[1]) * (b[0] - o[0])

def conveksni_omotac(tacke):
    tacke = sorted(tacke)
    donji, gornji = [], []


    for p in tacke:
        while len(donji) >= 2 and vektorski_proizvod(donji[-2], donji[-1], p) <= 0:
            donji.pop()
        donji.append(p)

    for p in reversed(tacke):
        while len(gornji) >= 2 and vektorski_proizvod(gornji[-2], gornji[-1], p) <= 0:
            gornji.pop()
        gornji.append(p)

    return donji[:-1] + gornji[:-1]

def povrs_poligona(poligon):
    n = len(poligon)
    area = 0
    for i in range(n):
        x1, y1 = poligon[i]
        x2, y2 = poligon[(i + 1) % n]
        area += x1 * y2 - y1 * x2
    return area / 2

def skoro_konveksni_omotac(tacke):
    n = len(tacke)
    min_povrs = float('inf')


    for i in combinations(tacke, n - 1):
        h = conveksni_omotac(list(i))
        povrs = povrs_poligona(h)
        min_povrs = min(min_povrs, povrs)

    return min_povrs

N = int(input())
tacke = [tuple(map(int, input().split())) for _ in range(N)]

rezultat = skoro_konveksni_omotac(tacke)
print(int(rezultat))